/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.internal.core.github.GithubAPI;
import com.aptana.git.internal.core.github.GithubRepository;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.json.simple.JSONObject;

class GithubPullRequest
implements IGithubPullRequest {
    private static final String URL = "url";
    private static final String HTML_URL = "html_url";
    private static final String NUMBER = "number";
    private static final String TITLE = "title";
    private static final String BODY = "body";
    private static final String BASE2 = "base";
    private static final String REPO = "repo";
    private static final String HEAD = "head";
    private static final String REF = "ref";
    private JSONObject json;

    GithubPullRequest(JSONObject json) {
        this.json = json;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getRawURL());
    }

    public URL getHTMLURL() throws MalformedURLException {
        return new URL((String)this.json.get((Object)HTML_URL));
    }

    private String getRawURL() {
        return (String)this.json.get((Object)URL);
    }

    public Long getNumber() {
        return (Long)this.json.get((Object)NUMBER);
    }

    public String getTitle() {
        return (String)this.json.get((Object)TITLE);
    }

    public String getBody() {
        return (String)this.json.get((Object)BODY);
    }

    public String getDisplayString() {
        return MessageFormat.format("#{0} - {1}", Long.toString(this.getNumber()), this.getTitle());
    }

    public IGithubRepository getHeadRepo() {
        JSONObject base = (JSONObject)this.json.get((Object)HEAD);
        return new GithubRepository((JSONObject)base.get((Object)REPO));
    }

    public IGithubRepository getBaseRepo() {
        JSONObject base = (JSONObject)this.json.get((Object)BASE2);
        return new GithubRepository((JSONObject)base.get((Object)REPO));
    }

    public IStatus merge(String commitMsg, IProgressMonitor monitor) {
        try {
            String input = null;
            if (!StringUtil.isEmpty((String)commitMsg)) {
                JSONObject json = new JSONObject();
                json.put((Object)"commit_message", (Object)commitMsg);
                input = json.toJSONString();
            }
            IGithubRepository baseRepo = this.getBaseRepo();
            JSONObject result = (JSONObject)new GithubAPI(GitPlugin.getDefault().getGithubManager().getUser()).put(MessageFormat.format("/repos/{0}/{1}/pulls/{2}/merge", baseRepo.getOwner(), baseRepo.getName(), this.getNumber()), input);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public String getHeadRef() {
        JSONObject base = (JSONObject)this.json.get((Object)HEAD);
        return (String)base.get((Object)REF);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getRawURL() == null ? 0 : this.getRawURL().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GithubPullRequest)) {
            return false;
        }
        GithubPullRequest other = (GithubPullRequest)obj;
        return !(this.getRawURL() == null ? other.getRawURL() != null : !this.getRawURL().equals(other.getRawURL()));
    }
}

